<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Adicionar campos de Informações Importantes na aba Avançado do produto
 */
function upgram_add_product_important_info_fields()
{
    global $post;
    
    $important_info = get_post_meta($post->ID, '_upgram_product_important_info', true);
    if (!is_array($important_info)) {
        $important_info = array();
    }
    
    // Garantir que temos 4 blocos
    while (count($important_info) < 4) {
        $important_info[] = array(
            'title' => '',
            'description' => '',
            'icon_type' => 'icon',
            'icon' => '',
            'image' => ''
        );
    }
    
    // Ícones SVG padrão
    $default_icons = array(
        '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 17L12 22L22 17" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 12L12 17L22 12" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
        '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M12 8V12L15 15" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
        '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9 12L11 14L15 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
        '<svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 2L15.09 8.26L22 9.27L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9.27L8.91 8.26L12 2Z" stroke="#7C51F3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>'
    );
    
    // Obter título da seção
    $section_title = get_post_meta($post->ID, '_upgram_important_info_section_title', true);
    if (empty($section_title)) {
        $section_title = 'Informações Importantes';
    }
    
    echo '<div class="options_group">';
    echo '<h3 style="padding: 10px 12px; margin: 0; background: #f5f5f5; border-bottom: 1px solid #ddd;">' . __('Informações Importantes do Produto', 'plugin-upgram') . '</h3>';
    echo '<div style="padding: 15px;">';
    
    // Botão para gerar Informações Importantes com IA
    $chatgpt_api_key = get_option('upgram_chatgpt_api_key', '');
    if (!empty($chatgpt_api_key)) {
        echo '<div style="background: #f0f9ff; border: 1px solid #bae6fd; border-radius: 6px; padding: 15px; margin-bottom: 20px;">';
        echo '<h4 style="margin: 0 0 10px 0; font-size: 14px; font-weight: 600; color: #0369a1;">🤖 Geração de Conteúdo com IA</h4>';
        echo '<p style="margin: 0 0 10px 0; color: #666; font-size: 13px;">Clique no botão abaixo para gerar automaticamente os 4 blocos de informações importantes.</p>';
        echo '<button type="button" id="upgram-generate-important-info-ai" class="button button-primary">🤖 Gerar texto IA</button>';
        echo '<span id="upgram-important-info-ai-loading" style="display: none; margin-left: 10px; color: #666;">⏳ Gerando...</span>';
        echo '<div id="upgram-important-info-ai-message" style="margin-top: 10px; display: none; padding: 10px; border-radius: 4px;"></div>';
        echo '</div>';
    }
    
    // Campo para título da seção
    echo '<p class="form-field">';
    echo '<label for="upgram_important_info_section_title" style="font-weight: 600; display: block; margin-bottom: 5px;">' . __('Título da Seção', 'plugin-upgram') . '</label>';
    echo '<input type="text" id="upgram_important_info_section_title" name="upgram_important_info_section_title" value="' . esc_attr($section_title) . '" class="widefat" style="width: 100%; padding: 8px;" placeholder="Informações Importantes" />';
    echo '<p class="description">' . __('Este título será exibido acima dos blocos na página do produto.', 'plugin-upgram') . '</p>';
    echo '</p>';
    
    // Campo de descrição da seção Informações Importantes
    $important_info_section_description = get_post_meta($post->ID, '_upgram_important_info_section_description', true);
    
    echo '<p class="form-field" style="margin-bottom: 20px;">';
    echo '<label for="upgram_important_info_section_description" style="display: block; margin-bottom: 5px; font-weight: 600;">Descrição da Seção (opcional):</label>';
    echo '<textarea id="upgram_important_info_section_description" name="upgram_important_info_section_description" class="widefat" rows="3" placeholder="Digite uma descrição para a seção Informações Importantes..." style="width: 100%; padding: 8px;">' . esc_textarea($important_info_section_description) . '</textarea>';
    echo '<p class="description" style="margin-top: 5px;">Esta descrição aparecerá abaixo do título da seção na página do produto.</p>';
    
    // Botão IA para gerar descrição
    $chatgpt_api_key = get_option('upgram_chatgpt_api_key', '');
    if (!empty($chatgpt_api_key)) {
        echo '<button type="button" id="upgram-generate-important-info-description-ai" class="button" style="margin-top: 5px;">🤖 Gerar descrição com IA</button>';
        echo '<span id="upgram-important-info-description-ai-loading" style="display: none; margin-left: 10px; color: #666;">⏳ Gerando...</span>';
        echo '<div id="upgram-important-info-description-ai-message" style="margin-top: 10px; display: none; padding: 10px; border-radius: 4px;"></div>';
    }
    echo '</p>';
    
    echo '<hr style="margin: 20px 0; border: none; border-top: 1px solid #ddd;">';
    
    echo '<p class="description">' . __('Configure até 4 blocos de informações importantes que serão exibidos na página do produto.', 'plugin-upgram') . '</p>';
    
    for ($i = 0; $i < 4; $i++) {
        $block = isset($important_info[$i]) ? $important_info[$i] : array(
            'title' => '',
            'description' => '',
            'icon_type' => 'icon',
            'icon' => '',
            'image' => ''
        );
        
        $default_icon = isset($default_icons[$i]) ? $default_icons[$i] : $default_icons[0];
        $current_icon = !empty($block['icon']) ? $block['icon'] : $default_icon;
        
        echo '<div style="border: 1px solid #ddd; padding: 15px; margin-bottom: 15px; background: #fff; border-radius: 4px;">';
        echo '<h4 style="margin: 0 0 15px 0; font-size: 14px; font-weight: 600;">' . sprintf(__('Bloco %d', 'plugin-upgram'), $i + 1) . '</h4>';
        
        // Título
        echo '<p class="form-field">';
        echo '<label for="upgram_important_info_' . $i . '_title">' . __('Título', 'plugin-upgram') . '</label>';
        echo '<input type="text" id="upgram_important_info_' . $i . '_title" name="upgram_important_info[' . $i . '][title]" value="' . esc_attr($block['title']) . '" class="widefat" style="width: 100%; padding: 8px;" />';
        echo '</p>';
        
        // Descrição
        echo '<p class="form-field">';
        echo '<label for="upgram_important_info_' . $i . '_description">' . __('Descrição', 'plugin-upgram') . '</label>';
        echo '<textarea id="upgram_important_info_' . $i . '_description" name="upgram_important_info[' . $i . '][description]" rows="3" class="widefat" style="width: 100%; padding: 8px;">' . esc_textarea($block['description']) . '</textarea>';
        echo '</p>';
        
        // Tipo de ícone
        echo '<p class="form-field">';
        echo '<label for="upgram_important_info_' . $i . '_icon_type">' . __('Tipo de Visualização', 'plugin-upgram') . '</label>';
        echo '<select id="upgram_important_info_' . $i . '_icon_type" name="upgram_important_info[' . $i . '][icon_type]" class="upgram-icon-type-select" style="width: 100%; padding: 8px;">';
        echo '<option value="icon" ' . selected($block['icon_type'], 'icon', false) . '>' . __('Ícone (SVG)', 'plugin-upgram') . '</option>';
        echo '<option value="image" ' . selected($block['icon_type'], 'image', false) . '>' . __('Imagem', 'plugin-upgram') . '</option>';
        echo '</select>';
        echo '</p>';
        
        // Ícone SVG
        $icon_field_style = ($block['icon_type'] === 'image') ? 'display: none;' : '';
        echo '<p class="form-field upgram-icon-field" style="' . $icon_field_style . '">';
        echo '<label for="upgram_important_info_' . $i . '_icon">' . __('Ícone (SVG)', 'plugin-upgram') . '</label>';
        echo '<textarea id="upgram_important_info_' . $i . '_icon" name="upgram_important_info[' . $i . '][icon]" rows="4" class="widefat" style="width: 100%; padding: 8px; font-family: monospace; font-size: 11px;">' . esc_textarea($current_icon) . '</textarea>';
        echo '<p class="description">' . __('Cole o código SVG do ícone ou deixe vazio para usar o ícone padrão.', 'plugin-upgram') . '</p>';
        echo '<div style="margin-top: 10px; padding: 10px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 4px;">';
        echo '<strong>' . __('Ícone Padrão:', 'plugin-upgram') . '</strong><br>';
        echo '<div style="margin-top: 5px;">' . $default_icon . '</div>';
        echo '</div>';
        echo '</p>';
        
        // Imagem
        $image_field_style = ($block['icon_type'] === 'icon') ? 'display: none;' : '';
        echo '<p class="form-field upgram-image-field" style="' . $image_field_style . '">';
        echo '<label for="upgram_important_info_' . $i . '_image">' . __('URL da Imagem', 'plugin-upgram') . '</label>';
        echo '<input type="url" id="upgram_important_info_' . $i . '_image" name="upgram_important_info[' . $i . '][image]" value="' . esc_url($block['image']) . '" class="widefat" style="width: 100%; padding: 8px;" />';
        echo '<p class="description">' . __('Cole a URL da imagem ou deixe vazio.', 'plugin-upgram') . '</p>';
        echo '</p>';
        
        echo '</div>';
    }
    
    echo '</div>';
    echo '</div>';
    
    // JavaScript para alternar entre ícone e imagem e gerar conteúdo com IA
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        var productId = <?php echo $post->ID; ?>;
        var aiNonce = '<?php echo wp_create_nonce('upgram_ai_nonce'); ?>';
        
        // Gerar descrição Informações Importantes com IA
        $('#upgram-generate-important-info-description-ai').on('click', function() {
            var $btn = $(this);
            var $loading = $('#upgram-important-info-description-ai-loading');
            var $message = $('#upgram-important-info-description-ai-message');
            
            $btn.prop('disabled', true);
            $loading.show();
            $message.hide();
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'upgram_generate_important_info_description',
                    security: aiNonce,
                    product_id: productId
                },
                success: function(response) {
                    if (response.success) {
                        $('#upgram_important_info_section_description').val(response.data.description);
                        $message.html('<div style="background: #d1fae5; color: #065f46; padding: 10px; border-radius: 4px;">✓ Descrição gerada com sucesso!</div>').show();
                    } else {
                        $message.html('<div style="background: #fee2e2; color: #991b1b; padding: 10px; border-radius: 4px;">✗ ' + (response.data.message || 'Erro ao gerar descrição') + '</div>').show();
                    }
                },
                error: function() {
                    $message.html('<div style="background: #fee2e2; color: #991b1b; padding: 10px; border-radius: 4px;">✗ Erro ao conectar com o servidor. Tente novamente.</div>').show();
                },
                complete: function() {
                    $btn.prop('disabled', false);
                    $loading.hide();
                }
            });
        });
        
        // Gerar Informações Importantes com IA
        $('#upgram-generate-important-info-ai').on('click', function() {
            var $btn = $(this);
            var $loading = $('#upgram-important-info-ai-loading');
            var $message = $('#upgram-important-info-ai-message');
            
            $btn.prop('disabled', true);
            $loading.show();
            $message.hide();
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'upgram_generate_important_info',
                    security: aiNonce,
                    product_id: productId
                },
                success: function(response) {
                    if (response.success && response.data && response.data.length === 4) {
                        // Preencher os campos de informações importantes
                        for (var i = 0; i < 4; i++) {
                            if (response.data[i]) {
                                $('#upgram_important_info_' + i + '_title').val(response.data[i].title || '');
                                $('#upgram_important_info_' + i + '_description').val(response.data[i].description || '');
                            }
                        }
                        $message.html('<div style="background: #d1fae5; color: #065f46; padding: 10px; border-radius: 4px;">✓ Conteúdo gerado com sucesso! Os 4 blocos foram preenchidos automaticamente.</div>').show();
                    } else {
                        $message.html('<div style="background: #fee2e2; color: #991b1b; padding: 10px; border-radius: 4px;">✗ ' + (response.data.message || 'Erro ao gerar informações importantes') + '</div>').show();
                    }
                },
                error: function() {
                    $message.html('<div style="background: #fee2e2; color: #991b1b; padding: 10px; border-radius: 4px;">✗ Erro ao conectar com o servidor. Tente novamente.</div>').show();
                },
                complete: function() {
                    $btn.prop('disabled', false);
                    $loading.hide();
                }
            });
        });
        
        $('.upgram-icon-type-select').on('change', function() {
            var $select = $(this);
            var value = $select.val();
            var $container = $select.closest('div[style*="border"]');
            
            if (value === 'icon') {
                $container.find('.upgram-icon-field').show();
                $container.find('.upgram-image-field').hide();
            } else {
                $container.find('.upgram-icon-field').hide();
                $container.find('.upgram-image-field').show();
            }
        });
    });
    </script>
    <?php
}

/**
 * Salvar Informações Importantes do produto
 */
function upgram_save_product_important_info($post_id)
{
    // Verificar se é um produto
    if (get_post_type($post_id) !== 'product') {
        return;
    }
    
    // Salvar título da seção (sempre processar, independente dos blocos)
    if (isset($_POST['upgram_important_info_section_title'])) {
        $section_title = sanitize_text_field($_POST['upgram_important_info_section_title']);
        if (!empty($section_title)) {
            update_post_meta($post_id, '_upgram_important_info_section_title', $section_title);
        } else {
            // Se vazio, usar padrão e salvar
            update_post_meta($post_id, '_upgram_important_info_section_title', 'Informações Importantes');
        }
    }
    
    // Salvar descrição da seção Informações Importantes (sempre processar, independente dos blocos)
    if (isset($_POST['upgram_important_info_section_description'])) {
        $important_info_section_description = wp_kses_post($_POST['upgram_important_info_section_description']);
        if (!empty($important_info_section_description)) {
            update_post_meta($post_id, '_upgram_important_info_section_description', $important_info_section_description);
        } else {
            delete_post_meta($post_id, '_upgram_important_info_section_description');
        }
    }
    
    // Verificar se os dados dos blocos foram enviados
    if (!isset($_POST['upgram_important_info']) || !is_array($_POST['upgram_important_info'])) {
        // Se não há informações dos blocos, limpar o meta dos blocos
        delete_post_meta($post_id, '_upgram_product_important_info');
        return; // Retornar aqui, mas título e descrição já foram salvos acima
    }
    
    $important_info = array();
    
    foreach ($_POST['upgram_important_info'] as $block) {
        $title = isset($block['title']) ? sanitize_text_field($block['title']) : '';
        $description = isset($block['description']) ? wp_kses_post($block['description']) : '';
        $icon_type = isset($block['icon_type']) && in_array($block['icon_type'], array('icon', 'image')) ? $block['icon_type'] : 'icon';
        $icon = isset($block['icon']) ? wp_kses_post($block['icon']) : '';
        $image = isset($block['image']) ? esc_url_raw($block['image']) : '';
        
        // Só adicionar se tiver título ou descrição
        if (!empty($title) || !empty($description)) {
            $important_info[] = array(
                'title' => $title,
                'description' => $description,
                'icon_type' => $icon_type,
                'icon' => $icon,
                'image' => $image
            );
        }
    }
    
    if (!empty($important_info)) {
        update_post_meta($post_id, '_upgram_product_important_info', $important_info);
    } else {
        delete_post_meta($post_id, '_upgram_product_important_info');
    }
}

// Adicionar campos na aba Avançado do produto
add_action('woocommerce_product_options_advanced', 'upgram_add_product_important_info_fields');

// Salvar Informações Importantes
add_action('woocommerce_process_product_meta', 'upgram_save_product_important_info');

